-- Generated by SceneGenEditor and loaded by scenegen_autogen.lua
local t = {
  __displayName="thatcher_swamp",
  biome="swamp",
  creature_spawners={
    battlefield={
      {
        color={ brightness=0, hue=0, saturation=0,},
        prop="bandiforest_grid_spawner_acid",
        sole_occupant_radius=2.0,
      },
    },
    miniboss={
      {
        color={ brightness=0, hue=0, saturation=0,},
        prop="spawner_miniboss",
        sole_occupant_radius=2.0,
      },
    },
    perimeter={
      {
        color={ brightness=0.0, hue=2.0, saturation=-13.0,},
        prop="bandiforest_bg_tendrilspawner",
        sole_occupant_radius=1.0,
      },
    },
  },
  destructibles={
    {
      dungeon_progress_constraints={
        midway={ easing="linear", likelihood={ from=1, to=1,},},
        near_boss={ easing="linear", likelihood={ from=0, to=0,},},
        start_run={ easing="linear", likelihood={ from=1, to=1,},},
      },
      prop="destructible_twigslime_shorty",
    },
    {
      dungeon_progress_constraints={
        midway={ easing="linear", likelihood={ from=1, to=1,},},
        near_boss={ easing="linear", likelihood={ from=0, to=0,},},
        start_run={ easing="linear", likelihood={ from=1, to=1,},},
      },
      prop="destructible_twigslime_tall",
    },
    {
      dungeon_progress_constraints={
        midway={ easing="linear", likelihood={ from=0, to=0,},},
        near_boss={ easing="linear", likelihood={ from=1, to=1,},},
        start_run={ easing="linear", likelihood={ from=0, to=0,},},
      },
      prop="destructible_deadbug_shorty",
    },
    {
      dungeon_progress_constraints={
        midway={ easing="linear", likelihood={ from=0, to=0,},},
        near_boss={ easing="linear", likelihood={ from=1, to=1,},},
        start_run={ easing="linear", likelihood={ from=0, to=0,},},
      },
      prop="destructible_deadbug_tall",
    },
  },
  dungeon="thatcher_swamp",
  environments={
    {
      label="Default",
      lighting={
        ambient="D7CBAAFF",
        clifflightdirection={ 0.050000000745058, -1.2000000476837, 0.40000000596046,},
        clifflightweight=0.44600000977516,
        clifframp="ramp_toni",
        cliffskirt="bandiforest_cliffacid",
        colorcube={
          boss="bandiforest_thatcher_nearboss_cc",
          entrance="bandiforest_thatcher_begin_cc",
        },
        ground_shadow_strength=0.20000000298023,
        rimlightcolor="E7E988FF",
      },
      room_types={ "hype", "miniboss", "monster", "empty", "entrance", "boss", "insert",},
      sky={
        backgroundGradientCurve={
          boss={
            { 0, 0.26864343881607, 0.46545451879501, 0.17602643370628,},
            { 0.054487179487179, 0.43641451001167, 0.38505786657333, 0.81454545259476,},
            { 0.14197530864198, 0.72463768720627, 0.45508646965027, 0.71291810274124,},
            { 0.2099358974359, 0.28945454955101, 0.35892367362976, 0.72363638877869,},
            { 0.27724358974359, 0.14642326533794, 0.23025308549404, 0.24369746446609,},
            { 0.39262820512821, 0.089987408288521, 0.068067400001002, 0.093448462228655,},
          },
          entrance={
            { 0, 0.43188288807869, 0.60663402080536, 0.62719297409058,},
            { 0.078189300411523, 0.53410971164703, 0.57894736528397, 0.42405354976654,},
            { 0.1328903654485, 0.23501135408878, 0.45893722772598, 0.23501135408878,},
            { 0.2093023255814, 0.12317672371864, 0.28019320964813, 0.26948755979538,},
            { 0.28737541528239, 0.086489908397198, 0.16484449803829, 0.16666668653488,},
            { 0.39867109634551, 0.086274512112141, 0.10196078568697, 0.086274512112141,},
          },
        },
        prop_fade_color="161A16FF",
      },
      water={
        water_settings={
          additive=1,
          cliff={
            bob_amplitude=0.13099999725819,
            bob_speed=0.46299999952316,
            wave_height=0.05799999833107,
            wave_outline=0.032000001519918,
            wave_period=0.41200000047684,
            wave_speed=1.2469999790192,
          },
          has_water=true,
          prop={
            bob_amplitude=0.19699999690056,
            bob_speed=0.44999998807907,
            wave_height=0.028000000864267,
            wave_outline=0.032000001519918,
            wave_period=0.29399999976158,
          },
          refraction=0.29899999499321,
          refraction_speed=4.0989999771118,
          water_color="021805FF",
          water_height=-1.0180000066757,
        },
      },
    },
    {
      label="Shops",
      lighting={
        ambient="D7CBAAFF",
        clifflightdirection={ 0.050000000745058, -1.2000000476837, 0.40000000596046,},
        clifflightweight=0.44600000977516,
        clifframp="ramp_toni",
        cliffskirt="bandiforest_cliffacid",
        colorcube={
          boss="bandiforest_thatcher_shopboss_cc",
          entrance="bandiforest_thatcher_shopbegin_cc",
        },
        ground_shadow_strength=0.20000000298023,
        rimlightcolor="E7E988FF",
      },
      room_types={
        "powerupgrade",
        "resource",
        "potion",
        "ranger",
        "food",
        "mystery",
        "wanderer",
        "quest",
      },
      sky={
        backgroundGradientCurve={
          boss={
            { 0, 0.26864343881607, 0.46545451879501, 0.17602643370628,},
            { 0.054487179487179, 0.43641451001167, 0.38505786657333, 0.81454545259476,},
            { 0.14197530864198, 0.72463768720627, 0.45508646965027, 0.71291810274124,},
            { 0.2099358974359, 0.28945454955101, 0.35892367362976, 0.72363638877869,},
            { 0.27724358974359, 0.14642326533794, 0.23025308549404, 0.24369746446609,},
            { 0.39262820512821, 0.089987408288521, 0.068067400001002, 0.093448462228655,},
          },
          entrance={
            { 0, 0.43188288807869, 0.60663402080536, 0.62719297409058,},
            { 0.078189300411523, 0.53410971164703, 0.57894736528397, 0.42405354976654,},
            { 0.1328903654485, 0.23501135408878, 0.45893722772598, 0.23501135408878,},
            { 0.2093023255814, 0.12317672371864, 0.28019320964813, 0.26948755979538,},
            { 0.28737541528239, 0.086489908397198, 0.16484449803829, 0.16666668653488,},
            { 0.39867109634551, 0.086274512112141, 0.10196078568697, 0.086274512112141,},
          },
        },
        prop_fade_color="161A16FF",
      },
      water={
        water_settings={
          additive=1,
          cliff={
            bob_amplitude=0.13099999725819,
            bob_speed=0.46299999952316,
            wave_height=0.05799999833107,
            wave_outline=0.032000001519918,
            wave_period=0.41200000047684,
            wave_speed=1.2469999790192,
          },
          has_water=true,
          prop={
            bob_amplitude=0.19699999690056,
            bob_speed=0.44999998807907,
            wave_height=0.028000000864267,
            wave_outline=0.032000001519918,
            wave_period=0.29399999976158,
          },
          refraction=0.29899999499321,
          refraction_speed=4.0989999771118,
          water_color="01070FFF",
          water_height=-0.74800002574921,
        },
      },
    },
    {
      label="Market",
      lighting={
        ambient="D7CBAAFF",
        clifflightdirection={ 0.050000000745058, -1.2000000476837, 0.40000000596046,},
        clifflightweight=0.44600000977516,
        clifframp="ramp_toni",
        cliffskirt="bandiforest_cliffacid",
        colorcube={
          boss="bandiforest_thatcher_marketboss_cc",
          entrance="bandiforest_thatcher_marketbegin_cc",
        },
        ground_shadow_strength=0.20000000298023,
        rimlightcolor="DE88E9FF",
      },
      room_types={ "market",},
      sky={
        backgroundGradientCurve={
          boss={
            { 0, 0.43528112769127, 0.3546407520771, 0.63285022974014,},
            { 0.067901234567901, 0.40381342172623, 0.4204515516758, 0.69082129001617,},
            { 0.1358024691358, 0.66183578968048, 0.50836664438248, 0.58843743801117,},
            { 0.2099358974359, 0.28945454955101, 0.35892367362976, 0.72363638877869,},
            { 0.27724358974359, 0.14642326533794, 0.23025308549404, 0.24369746446609,},
            { 0.39262820512821, 0.089987408288521, 0.068067400001002, 0.093448462228655,},
          },
          entrance={
            { 0, 0.43188288807869, 0.46584984660149, 0.62719297409058,},
            { 0.078189300411523, 0.53410971164703, 0.57894736528397, 0.42405354976654,},
            { 0.1328903654485, 0.23501135408878, 0.45893722772598, 0.23501135408878,},
            { 0.2093023255814, 0.12317672371864, 0.28019320964813, 0.26948755979538,},
            { 0.28737541528239, 0.086489908397198, 0.16484449803829, 0.16666668653488,},
            { 0.39867109634551, 0.086274512112141, 0.10196078568697, 0.086274512112141,},
          },
        },
        prop_fade_color="161A16FF",
      },
      water={
        water_settings={
          additive=1,
          cliff={
            bob_amplitude=0.13099999725819,
            bob_speed=0.46299999952316,
            wave_height=0.05799999833107,
            wave_outline=0.032000001519918,
            wave_period=0.41200000047684,
            wave_speed=1.2469999790192,
          },
          has_water=true,
          prop={
            bob_amplitude=0.19699999690056,
            bob_speed=0.44999998807907,
            wave_height=0.028000000864267,
            wave_outline=0.032000001519918,
            wave_period=0.29399999976158,
          },
          refraction=0.29899999499321,
          refraction_speed=4.0989999771118,
          water_color="01010CFF",
          water_height=-0.74800002574921,
        },
      },
    },
    {
      label="Metaunlock",
      lighting={
        ambient="D7CBAAFF",
        clifflightdirection={ 0.050000000745058, -1.2000000476837, 0.40000000596046,},
        clifflightweight=0.44600000977516,
        clifframp="ramp_toni",
        cliffskirt="bandiforest_cliffacid",
        colorcube={
          boss="bandiforest_thatcher_marketboss_cc",
          entrance="bandiforest_thatcher_marketbegin_cc",
        },
        ground_shadow_strength=0.20000000298023,
        rimlightcolor="DE88E9FF",
      },
      room_types={ "metaunlock",},
      sky={
        backgroundGradientCurve={
          boss={
            { 0, 0.43528112769127, 0.3546407520771, 0.63285022974014,},
            { 0.067901234567901, 0.40381342172623, 0.4204515516758, 0.69082129001617,},
            { 0.1358024691358, 0.66183578968048, 0.50836664438248, 0.58843743801117,},
            { 0.2099358974359, 0.28945454955101, 0.35892367362976, 0.72363638877869,},
            { 0.27724358974359, 0.14642326533794, 0.23025308549404, 0.24369746446609,},
            { 0.39262820512821, 0.089987408288521, 0.068067400001002, 0.093448462228655,},
          },
          entrance={
            { 0, 0.43188288807869, 0.46584984660149, 0.62719297409058,},
            { 0.078189300411523, 0.53410971164703, 0.57894736528397, 0.42405354976654,},
            { 0.1328903654485, 0.23501135408878, 0.45893722772598, 0.23501135408878,},
            { 0.2093023255814, 0.12317672371864, 0.28019320964813, 0.26948755979538,},
            { 0.28737541528239, 0.086489908397198, 0.16484449803829, 0.16666668653488,},
            { 0.39867109634551, 0.086274512112141, 0.10196078568697, 0.086274512112141,},
          },
        },
        prop_fade_color="161A16FF",
      },
      water={
        water_settings={
          additive=1,
          cliff={
            bob_amplitude=0.13099999725819,
            bob_speed=0.46299999952316,
            wave_height=0.05799999833107,
            wave_outline=0.032000001519918,
            wave_period=0.41200000047684,
            wave_speed=1.2469999790192,
          },
          has_water=true,
          prop={
            bob_amplitude=0.19699999690056,
            bob_speed=0.44999998807907,
            wave_height=0.028000000864267,
            wave_outline=0.032000001519918,
            wave_period=0.29399999976158,
          },
          refraction=0.29899999499321,
          refraction_speed=4.0989999771118,
          water_color="021805FF",
          water_height=-1.0180000066757,
        },
      },
    },
  },
  lighting=nil,
  particle_systems={  },
  rooms={
    "acidswamp_arena_esw",
    "acidswamp_arena_ew",
    "acidswamp_arena_nesw",
    "acidswamp_arena_new",
    "acidswamp_arena_nsw",
    "acidswamp_arena_nw",
    "acidswamp_arena_sw",
    "acidswamp_large_nesw",
    "acidswamp_miniboss_nesw",
    "acidswamp_quest_nesw",
    "acidswamp_small_nesw",
    "acidswamp_start_e",
    "acidswamp_start_n",
    "acidswamp_start_ne",
    "acidswamp_start_s",
    "acidswamp_thatcher_boss_s",
    "acidswamp_thatcher_hype_ns",
    "acidswamp_market_nesw",
    "acidswamp_metaunlock_nesw",
    "acidswamp_2_arena_nw",
    "acidswamp_2_arena_new",
    "acidswamp_2_arena_ew",
    "acidswamp_2_arena_esw",
  },
  sky=nil,
  tier=4.0,
  tile_group="thatcher_swamp",
  timer=4.0,
  underlay_props={  },
  water=nil,
  zone_gens={
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="Ground: bg, near_bg-TREE",
      non_walkable=false,
      offstage=true,
      particle_systems={  },
      room_types={
        "boss",
        "empty",
        "entrance",
        "food",
        "hype",
        "insert",
        "miniboss",
        "monster",
        "mystery",
        "potion",
        "powerupgrade",
        "ranger",
        "resource",
        "wanderer",
        "market",
        "metaunlock",
        "quest",
      },
      scene_props={
        {
          color_variants={ { color={ brightness=-6, hue=-1, saturation=6,}, likelihood=1,},},
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.69999998807907, to=0.0,},},
            near_boss={ easing="outQuad", likelihood={ from=0.0, to=0.0,},},
            start_run={ easing="inQuart", likelihood={ from=1.0, to=0.69999998807907,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=4.0, count=2.0, height=0, radius=2.5,},
          prop="bandiforest_bg_tree_vine",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={ { color={ brightness=0, hue=0, saturation=0,}, likelihood=1, zones={ "bg",},},},
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=0.40000000596046, to=1,},},
            near_boss={ easing="inSine", likelihood={ from=1, to=0.25,},},
            start_run={ easing="inQuart", likelihood={ from=0, to=0.40000000596046,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=4.0, count=1, height=0, radius=2.7999999523163,},
          prop="bandiforest_bg_lrgtree",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={ { color={ brightness=0, hue=0, saturation=0,}, likelihood=1, zones={ "bg",},},},
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.0, to=0.0,},},
            near_boss={ easing="inSine", likelihood={ from=0.0, to=0.75,},},
            start_run={ easing="inQuart", likelihood={ from=0, to=0.0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=4.0, count=1, height=0, radius=2.7999999523163,},
          prop="bandiforest_bg_lrgtree_cuts",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="bg_trees",
      seed_from="",
      spacers={  },
      tag="ZONE_GEN_TAG1",
      zones={ "bg", "near_bg",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=false,
      fxes={  },
      non_walkable=false,
      offstage=true,
      particle_systems={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=false,
          filter_by_tile_type=false,
          flags={  },
          layer="bg",
          particle_system="swamp_bubbles",
          placement={ buffer=0, count=1, height=0, radius=1,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      room_types={
        "boss",
        "empty",
        "entrance",
        "food",
        "hype",
        "insert",
        "miniboss",
        "monster",
        "mystery",
        "potion",
        "powerupgrade",
        "ranger",
        "resource",
        "wanderer",
        "market",
        "metaunlock",
        "quest",
      },
      scene_props={
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="inSine", likelihood={ from=1, to=1,},},
            near_boss={ easing="outQuad", likelihood={ from=1, to=0,},},
            start_run={ easing="inExpo", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1.5, count=1, height=0, radius=1.0,},
          prop="bandiforest_bg_lilypad",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0, to=0,},},
            near_boss={ easing="outQuad", likelihood={ from=0, to=1,},},
            start_run={ easing="linear", likelihood={ from=0, to=0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1.5, count=1, height=0, radius=1,},
          prop="bandiforest_bg_lilypad_cut",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="",
      spacers={
        {
          buffer=0,
          count=2.0,
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          height=0,
          radius=1,
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG2",
      zones={ "near_bg",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      non_walkable=false,
      offstage=true,
      particle_systems={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          layer="backdrop",
          particle_system="swamp_bubbles",
          placement={ buffer=0.5, count=2.0, height=-1.4299999475479, radius=1.0,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      room_types={
        "boss",
        "empty",
        "entrance",
        "food",
        "hype",
        "insert",
        "miniboss",
        "monster",
        "mystery",
        "potion",
        "powerupgrade",
        "ranger",
        "resource",
        "wanderer",
        "market",
        "metaunlock",
        "quest",
      },
      scene_props={
        {
          buffer=1.0,
          color_variants={ { color={ brightness=-7.0, hue=-1, saturation=2.0,}, likelihood=1,},},
          count=1.0,
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=0.5, to=0.0,},},
            near_boss={ easing="outQuad", likelihood={ from=0.0, to=0,},},
            start_run={ easing="inQuart", likelihood={ from=1, to=0.5,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          height=0,
          placement={ buffer=1.0, count=1.0, height=0, radius=2.0,},
          prop="bandiforest_bg_boulder_acid",
          radius=2.0,
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={ { color={ brightness=0.0, hue=2.0, saturation=-13.0,}, likelihood=1,},},
          dungeon_progress_constraints={
            midway={ easing="inSine", likelihood={ from=1, to=0.80000001192093,},},
            near_boss={ easing="linear", likelihood={ from=0.80000001192093, to=0.5,},},
            start_run={ easing="inQuart", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=2.0, height=0, radius=1.0,},
          prop="bandiforest_bg_tendril",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=0.34999999403954, to=1,},},
            near_boss={ easing="outQuad", likelihood={ from=1, to=1,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.34999999403954,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1.5, count=2.0, height=0, radius=1.0,},
          prop="bandiforest_bg_reed",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="inSine", likelihood={ from=1, to=1,},},
            near_boss={ easing="outQuad", likelihood={ from=1, to=0,},},
            start_run={ easing="inExpo", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1.0, count=2.0, height=0, radius=1.2000000476837,},
          prop="bandiforest_bg_lilypad",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0, to=0,},},
            near_boss={ easing="outQuad", likelihood={ from=0, to=1,},},
            start_run={ easing="linear", likelihood={ from=0, to=0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1.0, count=2.0, height=0, radius=1.2000000476837,},
          prop="bandiforest_bg_lilypad_cut",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="bg_trees",
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=0,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=1, height=0, radius=1,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG3",
      zones={ "bg",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="Ground: distant_bg, near_underlay-TREE",
      non_walkable=false,
      offstage=true,
      particle_systems={  },
      room_types={
        "boss",
        "empty",
        "entrance",
        "food",
        "hype",
        "insert",
        "miniboss",
        "monster",
        "mystery",
        "potion",
        "powerupgrade",
        "ranger",
        "resource",
        "wanderer",
        "market",
        "metaunlock",
        "quest",
      },
      scene_props={
        {
          color_variants={
            {
              color={ brightness=20.0, hue=-10.0, saturation=-6.0,},
              likelihood=1,
              zones={ "bg",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.69999998807907, to=0.0,},},
            near_boss={ easing="outQuad", likelihood={ from=0.0, to=0.0,},},
            start_run={ easing="inQuart", likelihood={ from=1.0, to=0.69999998807907,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=7.0, count=1, height=0, radius=1.0,},
          prop="bandiforest_bg_tree_vine",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={
            {
              color={ brightness=19, hue=3, saturation=-17,},
              likelihood=1,
              zones={ "distant_bg",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=0.40000000596046, to=1,},},
            near_boss={ easing="inSine", likelihood={ from=1, to=0.25,},},
            start_run={ easing="inQuart", likelihood={ from=0, to=0.40000000596046,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=8.0, count=1, height=0, radius=1.5,},
          prop="bandiforest_bg_lrgtree",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={
            {
              color={ brightness=19, hue=3, saturation=-17,},
              likelihood=1,
              zones={ "distant_bg",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.0, to=0.0,},},
            near_boss={ easing="inSine", likelihood={ from=0.0, to=0.75,},},
            start_run={ easing="inQuart", likelihood={ from=0, to=0.0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=8.0, count=1, height=0, radius=1.0,},
          prop="bandiforest_bg_lrgtree_cuts",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="distant_bg_trees",
      seed_from="",
      spacers={  },
      tag="ZONE_GEN_TAG4",
      zones={ "distant_bg", "near_underlay",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      non_walkable=false,
      offstage=true,
      particle_systems={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          layer="backdrop",
          particle_system="swamp_bubbles",
          placement={ buffer=0.5, count=1, height=-1.4299999475479, radius=1.0,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      room_types={
        "boss",
        "empty",
        "entrance",
        "food",
        "hype",
        "insert",
        "miniboss",
        "monster",
        "mystery",
        "potion",
        "powerupgrade",
        "ranger",
        "resource",
        "wanderer",
        "market",
        "metaunlock",
        "quest",
      },
      scene_props={
        {
          color_variants={
            {
              color={ brightness=16.0, hue=-5.0, saturation=-9.0,},
              likelihood=1.0,
              zones={ "distant_bg",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=0.5, to=0,},},
            near_boss={ easing="outQuad", likelihood={ from=0, to=0,},},
            start_run={ easing="inQuart", likelihood={ from=1, to=0.5,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1.0, count=1, height=0, radius=2.0,},
          prop="bandiforest_bg_boulder_acid",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={
            {
              color={ brightness=20.0, hue=3.0, saturation=-13.0,},
              likelihood=1.0,
              zones={ "distant_bg",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="inSine", likelihood={ from=1, to=0.80000001192093,},},
            near_boss={ easing="linear", likelihood={ from=0.80000001192093, to=0.5,},},
            start_run={ easing="inQuart", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1.0, height=0, radius=1,},
          prop="bandiforest_bg_tendril",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={ { color={ brightness=19.0, hue=-11.0, saturation=-5.0,}, likelihood=1,},},
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=0.34999999403954, to=1,},},
            near_boss={ easing="outQuad", likelihood={ from=1, to=1,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.34999999403954,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1.0, count=2.0, height=0, radius=1.5,},
          prop="bandiforest_bg_reed",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={ { color={ brightness=39.0, hue=-11.0, saturation=-13.0,}, likelihood=1,},},
          dungeon_progress_constraints={
            midway={ easing="inSine", likelihood={ from=1, to=1,},},
            near_boss={ easing="outQuad", likelihood={ from=1, to=0,},},
            start_run={ easing="inExpo", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1.0, count=2, height=0, radius=1.5,},
          prop="bandiforest_bg_lilypad",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={ { color={ brightness=39, hue=-11, saturation=-13,}, likelihood=1,},},
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0, to=0,},},
            near_boss={ easing="outQuad", likelihood={ from=0, to=1,},},
            start_run={ easing="linear", likelihood={ from=0, to=0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=1,},
          prop="bandiforest_bg_lilypad_cut",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="distant_bg_trees",
      spacers={
        {
          buffer=0,
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=0.0,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          height=0,
          radius=1,
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
        {
          buffer=0,
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=0.0060000000521541,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          height=0,
          radius=2.0,
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG5",
      zones={ "distant_bg", "near_underlay",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      non_walkable=false,
      offstage=true,
      particle_systems={  },
      room_types={
        "boss",
        "empty",
        "entrance",
        "food",
        "hype",
        "insert",
        "miniboss",
        "monster",
        "mystery",
        "potion",
        "powerupgrade",
        "ranger",
        "resource",
        "wanderer",
        "market",
        "metaunlock",
        "quest",
      },
      scene_props={
        {
          color_variants={
            {
              color={ brightness=-14.0, hue=27, saturation=-25,},
              likelihood=1.0,
              zones={ "underlay",},
            },
            { color={ brightness=-12.0, hue=21.0, saturation=-18.0,}, likelihood=1,},
          },
          dungeon_progress_constraints={
            midway={ easing="outQuart", likelihood={ from=0.69999998807907, to=0.0,},},
            near_boss={ easing="outQuad", likelihood={ from=0.0, to=0,},},
            start_run={ easing="inQuart", likelihood={ from=1, to=0.69999998807907,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1.0, count=1, height=0, radius=1,},
          prop="bandiforest_ul_fartree",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={
            { color={ brightness=0, hue=0, saturation=0,}, likelihood=1,},
            { color={ brightness=-3.0, hue=-5.0, saturation=-9.0,}, likelihood=1,},
          },
          dungeon_progress_constraints={
            midway={ easing="outQuart", likelihood={ from=0.30000001192093, to=1.0,},},
            near_boss={ easing="inQuad", likelihood={ from=1.0, to=1.0,},},
            start_run={ easing="inQuart", likelihood={ from=0.0, to=0.30000001192093,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=2.0, count=1, height=0, radius=1.0,},
          prop="bandiforest_ul_fartreelrg",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="",
      spacers={  },
      tag="ZONE_GEN_TAG6",
      zones={ "underlay",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      non_walkable=false,
      offstage=true,
      particle_systems={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          layer="backdrop",
          particle_system="swamp_bubbles",
          placement={ buffer=1, count=1, height=-1.4299999475479, radius=1.0,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      room_types={
        "boss",
        "empty",
        "entrance",
        "food",
        "hype",
        "insert",
        "miniboss",
        "monster",
        "mystery",
        "potion",
        "powerupgrade",
        "ranger",
        "resource",
        "wanderer",
        "market",
        "metaunlock",
        "quest",
      },
      scene_props={
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="inSine", likelihood={ from=1, to=1,},},
            near_boss={ easing="outQuad", likelihood={ from=1, to=0,},},
            start_run={ easing="inExpo", likelihood={ from=1, to=1,},},
          },
          enabled=false,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1.0, count=1, height=0, radius=1.0,},
          prop="bandiforest_bg_lilypad",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0, to=0,},},
            near_boss={ easing="outQuad", likelihood={ from=0, to=1,},},
            start_run={ easing="linear", likelihood={ from=0, to=0,},},
          },
          enabled=false,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1.0, count=1, height=0, radius=1.5,},
          prop="bandiforest_bg_lilypad_cut",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=0.34999999403954, to=1,},},
            near_boss={ easing="outQuad", likelihood={ from=1, to=1,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.34999999403954,},},
          },
          enabled=false,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1, count=2, height=0, radius=1,},
          prop="bandiforest_bg_reed",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="",
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=4.0, height=0, radius=1,},
          tile_type_filter_shape="Point",
        },
      },
      tag="ZONE_GEN_TAG7",
      zones={ "near_side",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="Ground: side, distant_side-TREE",
      non_walkable=false,
      offstage=true,
      particle_systems={  },
      room_types={
        "boss",
        "empty",
        "entrance",
        "food",
        "hype",
        "insert",
        "miniboss",
        "monster",
        "mystery",
        "potion",
        "powerupgrade",
        "ranger",
        "resource",
        "wanderer",
        "market",
        "metaunlock",
        "quest",
      },
      scene_props={
        {
          color_variants={
            {
              color={ brightness=-19.0, hue=7.0, saturation=-6.0,},
              likelihood=1.0,
              zones={ "side",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.69999998807907, to=0.0,},},
            near_boss={ easing="outQuad", likelihood={ from=0.0, to=0.0,},},
            start_run={ easing="inQuart", likelihood={ from=1.0, to=0.69999998807907,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=3.5, count=1, height=0, radius=1.5,},
          prop="bandiforest_bg_tree_vine",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={
            { color={ brightness=-13, hue=0, saturation=0,}, likelihood=1, zones={ "side",},},
          },
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=0.40000000596046, to=1,},},
            near_boss={ easing="inSine", likelihood={ from=1, to=0.25,},},
            start_run={ easing="inQuart", likelihood={ from=0, to=0.40000000596046,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=2.5, count=1, height=0, radius=3.5,},
          prop="bandiforest_bg_lrgtree",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={
            { color={ brightness=-13, hue=0, saturation=0,}, likelihood=1, zones={ "side",},},
          },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.0, to=0.0,},},
            near_boss={ easing="inSine", likelihood={ from=0.0, to=0.75,},},
            start_run={ easing="inQuart", likelihood={ from=0, to=0.0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=2.5, count=1, height=0, radius=3.5,},
          prop="bandiforest_bg_lrgtree_cuts",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="side_trees",
      seed_from="",
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=1, height=0, radius=1,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG8",
      zones={ "side", "distant_side",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      non_walkable=false,
      offstage=true,
      particle_systems={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          layer="backdrop",
          particle_system="swamp_bubbles",
          placement={ buffer=1.0, count=1, height=-1.4299999475479, radius=0.80000001192093,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      room_types={
        "boss",
        "empty",
        "entrance",
        "food",
        "hype",
        "insert",
        "miniboss",
        "monster",
        "mystery",
        "potion",
        "powerupgrade",
        "ranger",
        "resource",
        "wanderer",
        "market",
        "metaunlock",
        "quest",
      },
      scene_props={
        {
          color_variants={
            {
              color={ brightness=-23.0, hue=-4.0, saturation=-13.0,},
              likelihood=1.0,
              zones={ "side", "distant_side",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="inSine", likelihood={ from=1.0, to=0.80000001192093,},},
            near_boss={ easing="linear", likelihood={ from=0.80000001192093, to=0.5,},},
            start_run={ easing="inQuart", likelihood={ from=1, to=1.0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1.0, height=0, radius=1,},
          prop="bandiforest_bg_tendril",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={ { color={ brightness=-12.0, hue=0, saturation=7,}, likelihood=1,},},
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=0.34999999403954, to=1,},},
            near_boss={ easing="outQuad", likelihood={ from=1, to=1,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.34999999403954,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1.0, count=2.0, height=0, radius=1.5,},
          prop="bandiforest_bg_reed",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={ { color={ brightness=-14.0, hue=-8.0, saturation=5.0,}, likelihood=1,},},
          dungeon_progress_constraints={
            midway={ easing="inSine", likelihood={ from=1, to=1,},},
            near_boss={ easing="outQuad", likelihood={ from=1, to=0,},},
            start_run={ easing="inExpo", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.5, count=2.0, height=0, radius=1.5,},
          prop="bandiforest_bg_lilypad",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={ { color={ brightness=-14, hue=-8, saturation=5,}, likelihood=1,},},
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0, to=0,},},
            near_boss={ easing="outQuad", likelihood={ from=0, to=1,},},
            start_run={ easing="linear", likelihood={ from=0, to=0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=1,},
          prop="bandiforest_bg_lilypad_cut",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={ { color={ brightness=-14.0, hue=0, saturation=7,}, likelihood=1,},},
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=0.5, to=0,},},
            near_boss={ easing="outQuad", likelihood={ from=0, to=0,},},
            start_run={ easing="inQuart", likelihood={ from=1, to=0.5,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1, count=1, height=0, radius=2,},
          prop="bandiforest_bg_boulder_acid",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="side_trees",
      spacers={
        {
          buffer=0,
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          height=0,
          radius=1,
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG9",
      zones={ "side", "distant_side",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="Ground_nearfg",
      non_walkable=false,
      offstage=true,
      particle_systems={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=false,
          filter_by_tile_type=false,
          flags={  },
          layer="bg",
          particle_system="swamp_bubbles",
          placement={ buffer=2, count=1, height=-1.4299999475479, radius=1.5,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      room_types={
        "boss",
        "empty",
        "entrance",
        "food",
        "hype",
        "insert",
        "miniboss",
        "monster",
        "mystery",
        "potion",
        "powerupgrade",
        "ranger",
        "resource",
        "wanderer",
        "market",
        "metaunlock",
        "quest",
      },
      scene_props={
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="inSine", likelihood={ from=1, to=0.80000001192093,},},
            near_boss={ easing="linear", likelihood={ from=0.80000001192093, to=0.5,},},
            start_run={ easing="inQuart", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1.0, count=1, height=0, radius=1.5,},
          prop="bandiforest_fg_tendril",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={
            {
              color={ brightness=23, hue=-18, saturation=-15,},
              likelihood=1,
              zones={ "distant_bg",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=0.34999999403954, to=1,},},
            near_boss={ easing="outQuad", likelihood={ from=1, to=1,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.34999999403954,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=1,},
          prop="bandiforest_fg_reed",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0, to=0,},},
            near_boss={ easing="outQuad", likelihood={ from=0, to=1,},},
            start_run={ easing="linear", likelihood={ from=0, to=0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=2, count=1, height=0, radius=1,},
          prop="bandiforest_fg_lilypadcut",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="inSine", likelihood={ from=1, to=1,},},
            near_boss={ easing="outQuad", likelihood={ from=1, to=0,},},
            start_run={ easing="inExpo", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1.2999999523163, count=1, height=0, radius=1.7000000476837,},
          prop="bandiforest_fg_lilypad",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="",
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=3.0, height=0, radius=1,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG10",
      zones={ "near_fg",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      non_walkable=false,
      offstage=true,
      particle_systems={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          layer="bg",
          particle_system="swamp_bubbles",
          placement={ buffer=2, count=1, height=-1.4299999475479, radius=1.5,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      room_types={
        "boss",
        "empty",
        "entrance",
        "food",
        "hype",
        "insert",
        "miniboss",
        "monster",
        "mystery",
        "potion",
        "powerupgrade",
        "ranger",
        "resource",
        "wanderer",
        "market",
        "metaunlock",
        "quest",
      },
      scene_props={
        {
          color_variants={
            {
              color={ brightness=-16, hue=15, saturation=4,},
              likelihood=1,
              zones={ "fg_side", "distant_fg",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=3.5, count=1, height=0, radius=1.5,},
          prop="bandiforest_fg_boulder_slime",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={ { color={ brightness=-7, hue=11.0, saturation=12.0,}, likelihood=1,},},
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.80000001192093, to=0.40000000596046,},},
            near_boss={ easing="outQuad", likelihood={ from=0.40000000596046, to=0.20000000298023,},},
            start_run={ easing="inQuart", likelihood={ from=1, to=0.80000001192093,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1.0, count=1, height=0, radius=1,},
          prop="bandiforest_fg_tendril",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="inSine", likelihood={ from=1, to=1.0,},},
            near_boss={ easing="outQuad", likelihood={ from=1.0, to=0,},},
            start_run={ easing="inExpo", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=2.0, count=1, height=0, radius=1.5,},
          prop="bandiforest_fg_lilypad",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0, to=0,},},
            near_boss={ easing="outQuad", likelihood={ from=0, to=1,},},
            start_run={ easing="linear", likelihood={ from=0, to=0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=2, count=1, height=0, radius=1.5,},
          prop="bandiforest_fg_lilypadcut",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={ { color={ brightness=-10, hue=0, saturation=12,}, likelihood=1,},},
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=0.34999999403954, to=1,},},
            near_boss={ easing="outQuad", likelihood={ from=1, to=1,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.34999999403954,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=2, count=2.0, height=0, radius=1.5,},
          prop="bandiforest_fg_reed",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="",
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=1, height=0, radius=1,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=1, height=0, radius=1.5,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG11",
      zones={ "fg",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      non_walkable=false,
      offstage=true,
      particle_systems={  },
      room_types={
        "boss",
        "empty",
        "entrance",
        "food",
        "hype",
        "insert",
        "miniboss",
        "monster",
        "mystery",
        "potion",
        "powerupgrade",
        "ranger",
        "resource",
        "wanderer",
        "market",
        "metaunlock",
        "quest",
      },
      scene_props={
        {
          color_variants={
            {
              color={ brightness=-32.0, hue=15.0, saturation=4.0,},
              likelihood=1.0,
              zones={ "fg_side", "distant_fg",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="outQuart", likelihood={ from=1.0, to=1,},},
            near_boss={ easing="inQuart", likelihood={ from=1, to=0.75,},},
            start_run={ easing="inQuart", likelihood={ from=1.0, to=1.0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=3.5, count=1, height=0, radius=1.5,},
          prop="bandiforest_fg_boulder_slime",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={ { color={ brightness=-23.0, hue=9.0, saturation=1.0,}, likelihood=1,},},
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.80000001192093, to=0.40000000596046,},},
            near_boss={ easing="outQuad", likelihood={ from=0.40000000596046, to=0.20000000298023,},},
            start_run={ easing="inQuart", likelihood={ from=1, to=0.80000001192093,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1.0, count=1, height=0, radius=1,},
          prop="bandiforest_fg_tendril",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={ { color={ brightness=-10.0, hue=0, saturation=12.0,}, likelihood=1,},},
          dungeon_progress_constraints={
            midway={ easing="inSine", likelihood={ from=1, to=1.0,},},
            near_boss={ easing="outQuad", likelihood={ from=1.0, to=0,},},
            start_run={ easing="inExpo", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=2.5, count=1, height=0, radius=1.0,},
          prop="bandiforest_fg_lilypad",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={ { color={ brightness=-10, hue=0, saturation=12,}, likelihood=1,},},
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0, to=0,},},
            near_boss={ easing="outQuad", likelihood={ from=0, to=1,},},
            start_run={ easing="linear", likelihood={ from=0, to=0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=2.5, count=1, height=0, radius=1,},
          prop="bandiforest_fg_lilypadcut",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={ { color={ brightness=-29.0, hue=8.0, saturation=5.0,}, likelihood=1,},},
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=0.34999999403954, to=1,},},
            near_boss={ easing="outQuad", likelihood={ from=1, to=1,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.34999999403954,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=2.5, count=2.0, height=0, radius=1,},
          prop="bandiforest_fg_reed",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="",
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=1, height=0, radius=1,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=1, height=0, radius=1.5,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG12",
      zones={ "distant_fg",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="Ground: fg_side-TREE",
      non_walkable=false,
      offstage=true,
      particle_systems={  },
      room_types={
        "boss",
        "empty",
        "entrance",
        "food",
        "hype",
        "insert",
        "miniboss",
        "monster",
        "mystery",
        "potion",
        "powerupgrade",
        "ranger",
        "resource",
        "wanderer",
        "market",
        "metaunlock",
        "quest",
      },
      scene_props={
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1.0, to=1.0,},},
            near_boss={ easing="inSine", likelihood={ from=1.0, to=0,},},
            start_run={ easing="linear", likelihood={ from=1, to=1.0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1.5, count=1, height=0, radius=2.5,},
          prop="bandiforest_fg_tree_vine",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0, to=0,},},
            near_boss={ easing="inSine", likelihood={ from=0, to=1.0,},},
            start_run={ easing="inQuart", likelihood={ from=0, to=0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=4, count=1, height=0, radius=3,},
          prop="bandiforest_fg_tree_cut",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="fg_side_tree",
      seed_from="",
      spacers={  },
      tag="ZONE_GEN_TAG13",
      zones={ "fg_side",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      non_walkable=false,
      offstage=true,
      particle_systems={  },
      room_types={
        "boss",
        "empty",
        "entrance",
        "food",
        "hype",
        "insert",
        "miniboss",
        "monster",
        "mystery",
        "potion",
        "powerupgrade",
        "ranger",
        "resource",
        "wanderer",
        "market",
        "metaunlock",
        "quest",
      },
      scene_props={
        {
          color_variants={
            {
              color={ brightness=-16, hue=15, saturation=4,},
              likelihood=1,
              zones={ "fg_side", "distant_fg",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=3.5, count=1, height=0, radius=1.5,},
          prop="bandiforest_fg_boulder_slime",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={ { color={ brightness=-28, hue=12, saturation=4,}, likelihood=1,},},
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.80000001192093, to=0.40000000596046,},},
            near_boss={ easing="outQuad", likelihood={ from=0.40000000596046, to=0.20000000298023,},},
            start_run={ easing="inQuart", likelihood={ from=1, to=0.80000001192093,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1.0, count=1, height=0, radius=1,},
          prop="bandiforest_fg_tendril",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={ { color={ brightness=-10, hue=0, saturation=12,}, likelihood=1,},},
          dungeon_progress_constraints={
            midway={ easing="inSine", likelihood={ from=1, to=1.0,},},
            near_boss={ easing="outQuad", likelihood={ from=1.0, to=0,},},
            start_run={ easing="inExpo", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=2.5, count=1, height=0, radius=1,},
          prop="bandiforest_fg_lilypad",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={ { color={ brightness=-10, hue=0, saturation=12,}, likelihood=1,},},
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0, to=0,},},
            near_boss={ easing="outQuad", likelihood={ from=0, to=1,},},
            start_run={ easing="linear", likelihood={ from=0, to=0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=2.5, count=1, height=0, radius=1,},
          prop="bandiforest_fg_lilypadcut",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={ { color={ brightness=-10, hue=0, saturation=12,}, likelihood=1,},},
          dungeon_progress_constraints={
            midway={ easing="outSine", likelihood={ from=0.34999999403954, to=1,},},
            near_boss={ easing="outQuad", likelihood={ from=1, to=1,},},
            start_run={ easing="inQuint", likelihood={ from=0, to=0.34999999403954,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=2.5, count=2.0, height=0, radius=1,},
          prop="bandiforest_fg_reed",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="fg_side_tree",
      spacers={  },
      tag="ZONE_GEN_TAG14",
      zones={ "fg_side",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="Particles: Bubbles 6",
      non_walkable=false,
      offstage=true,
      particle_systems={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=false,
          filter_by_tile_type=true,
          flags={  },
          particle_system="acidpool_bubbles_1x1",
          placement={ buffer=0, count=1.0, height=0, radius=1.0,},
          tile_type_filter_shape="Circle",
          tile_types={ "pool",},
        },
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=false,
          filter_by_tile_type=true,
          flags={  },
          particle_system="acidpool_bubbles_2x2",
          placement={ buffer=0.0, count=2.0, height=0, radius=2.0999999046326,},
          tile_type_filter_shape="Circle",
          tile_types={ "pool",},
        },
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=false,
          filter_by_tile_type=true,
          flags={  },
          particle_system="acidpool_bubbles_4x4",
          placement={ buffer=0.0, count=2.0, height=0, radius=3.2000000476837,},
          tile_type_filter_shape="Circle",
          tile_types={ "pool",},
        },
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=true,
          flags={  },
          particle_system="acidpool_bubbles_6x6",
          placement={ buffer=0.0, count=1, height=0, radius=5.0,},
          tile_type_filter_shape="Circle",
          tile_types={ "pool",},
        },
      },
      room_types={
        "boss",
        "empty",
        "entrance",
        "food",
        "hype",
        "insert",
        "market",
        "miniboss",
        "monster",
        "mystery",
        "potion",
        "powerupgrade",
        "quest",
        "ranger",
        "resource",
        "wanderer",
        "metaunlock",
      },
      scene_props={  },
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=false,
          filter_by_tile_type=false,
          placement={ buffer=0, count=1, height=0, radius=1,},
          tile_type_filter_shape="Point",
        },
      },
      tag="ZONE_GEN_TAG15",
      zones={ "middle", "inside_perimeter", "front_perimeter",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="Particles: Bubbles 4",
      non_walkable=false,
      offstage=true,
      particle_systems={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=false,
          filter_by_tile_type=true,
          flags={  },
          particle_system="acidpool_bubbles_1x1",
          placement={ buffer=0, count=1, height=0, radius=1,},
          tile_type_filter_shape="Circle",
          tile_types={ "pool",},
        },
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=false,
          filter_by_tile_type=true,
          flags={  },
          particle_system="acidpool_bubbles_2x2",
          placement={ buffer=0, count=2, height=0, radius=2.0999999046326,},
          tile_type_filter_shape="Circle",
          tile_types={ "pool",},
        },
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=true,
          flags={  },
          particle_system="acidpool_bubbles_4x4",
          placement={ buffer=0, count=2, height=0, radius=3.2000000476837,},
          tile_type_filter_shape="Circle",
          tile_types={ "pool",},
        },
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=false,
          filter_by_tile_type=true,
          flags={  },
          particle_system="acidpool_bubbles_6x6",
          placement={ buffer=0, count=1, height=0, radius=5,},
          tile_type_filter_shape="Circle",
          tile_types={ "pool",},
        },
      },
      room_types={
        "boss",
        "empty",
        "entrance",
        "food",
        "hype",
        "insert",
        "market",
        "miniboss",
        "monster",
        "mystery",
        "potion",
        "powerupgrade",
        "quest",
        "ranger",
        "resource",
        "wanderer",
        "metaunlock",
      },
      scene_props={  },
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=false,
          filter_by_tile_type=false,
          placement={ buffer=0, count=1, height=0, radius=1,},
          tile_type_filter_shape="Point",
        },
      },
      tag="ZONE_GEN_TAG16",
      zones={ "middle", "inside_perimeter", "front_perimeter",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="Particles: Bubbles 2",
      non_walkable=false,
      offstage=true,
      particle_systems={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=false,
          filter_by_tile_type=true,
          flags={  },
          particle_system="acidpool_bubbles_1x1",
          placement={ buffer=0, count=1, height=0, radius=1,},
          tile_type_filter_shape="Circle",
          tile_types={ "pool",},
        },
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=true,
          flags={  },
          particle_system="acidpool_bubbles_2x2",
          placement={ buffer=0, count=2, height=0, radius=2.0999999046326,},
          tile_type_filter_shape="Circle",
          tile_types={ "pool",},
        },
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=false,
          filter_by_tile_type=true,
          flags={  },
          particle_system="acidpool_bubbles_4x4",
          placement={ buffer=0, count=2, height=0, radius=3.2000000476837,},
          tile_type_filter_shape="Circle",
          tile_types={ "pool",},
        },
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=false,
          filter_by_tile_type=true,
          flags={  },
          particle_system="acidpool_bubbles_6x6",
          placement={ buffer=0, count=1, height=0, radius=5,},
          tile_type_filter_shape="Circle",
          tile_types={ "pool",},
        },
      },
      room_types={
        "boss",
        "empty",
        "entrance",
        "food",
        "hype",
        "insert",
        "market",
        "miniboss",
        "monster",
        "mystery",
        "potion",
        "powerupgrade",
        "quest",
        "ranger",
        "resource",
        "wanderer",
        "metaunlock",
      },
      scene_props={  },
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=false,
          filter_by_tile_type=false,
          placement={ buffer=0, count=1, height=0, radius=1,},
          tile_type_filter_shape="Point",
        },
      },
      tag="ZONE_GEN_TAG17",
      zones={ "middle", "inside_perimeter", "front_perimeter",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=true,
          fx="fx_acid_mudbubble",
          placement={ buffer=0.0, count=1, height=0, radius=1.0,},
          tile_type_filter_shape="Circle",
          tile_types={ "pool",},
        },
      },
      name="Particles: Bubbles 1",
      non_walkable=false,
      offstage=true,
      particle_systems={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=true,
          flags={  },
          particle_system="acidpool_bubbles_1x1",
          placement={ buffer=0.0, count=2.0, height=0, radius=1.0,},
          tile_type_filter_shape="Circle",
          tile_types={ "pool",},
        },
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=false,
          filter_by_tile_type=true,
          flags={  },
          particle_system="acidpool_bubbles_2x2",
          placement={ buffer=0, count=2, height=0, radius=2.0999999046326,},
          tile_type_filter_shape="Circle",
          tile_types={ "pool",},
        },
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=false,
          filter_by_tile_type=true,
          flags={  },
          particle_system="acidpool_bubbles_4x4",
          placement={ buffer=0, count=2, height=0, radius=3.2000000476837,},
          tile_type_filter_shape="Circle",
          tile_types={ "pool",},
        },
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=false,
          filter_by_tile_type=true,
          flags={  },
          particle_system="acidpool_bubbles_6x6",
          placement={ buffer=0, count=1, height=0, radius=5,},
          tile_type_filter_shape="Circle",
          tile_types={ "pool",},
        },
      },
      room_types={
        "boss",
        "empty",
        "entrance",
        "food",
        "hype",
        "insert",
        "market",
        "miniboss",
        "monster",
        "mystery",
        "potion",
        "powerupgrade",
        "quest",
        "ranger",
        "resource",
        "wanderer",
        "metaunlock",
      },
      scene_props={  },
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=false,
          filter_by_tile_type=true,
          placement={ buffer=0, count=1, height=0, radius=1,},
          tile_type_filter_shape="Point",
          tile_types={ "pool",},
        },
      },
      tag="ZONE_GEN_TAG18",
      zones={ "middle", "inside_perimeter", "front_perimeter",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="Particles: Bubbles 0.75",
      non_walkable=false,
      offstage=true,
      particle_systems={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=true,
          flags={  },
          particle_system="acidpool_bubbles_0_75",
          placement={ buffer=0.25, count=1, height=0, radius=0.75,},
          tile_type_filter_shape="Circle",
          tile_types={ "pool",},
        },
      },
      room_types={
        "boss",
        "empty",
        "entrance",
        "food",
        "hype",
        "insert",
        "market",
        "miniboss",
        "monster",
        "mystery",
        "potion",
        "powerupgrade",
        "quest",
        "ranger",
        "resource",
        "wanderer",
        "metaunlock",
      },
      scene_props={  },
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=false,
          filter_by_tile_type=true,
          placement={ buffer=0, count=1, height=0, radius=1,},
          tile_type_filter_shape="Point",
          tile_types={ "pool",},
        },
      },
      tag="ZONE_GEN_TAG19",
      zones={ "middle", "inside_perimeter", "front_perimeter",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="entrance_perimeter",
      non_walkable=false,
      offstage=false,
      particle_systems={  },
      room_types={ "entrance",},
      scene_props={
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=1.5,},
          prop="bandiforest_grid_lilyrock1",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=1.2,},
          prop="bandiforest_grid_lilyrock2",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="mossy_rocks",
      seed_from="",
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=6.0, height=0, radius=1.9,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG20",
      zones={ "front_perimeter", "inside_perimeter",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="entrance_perimeter_fill",
      non_walkable=false,
      offstage=false,
      particle_systems={  },
      room_types={ "entrance",},
      scene_props={
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=1,},
          prop="bandiforest_grid_slime",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          buffer=0,
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          height=0,
          prop="bandiforest_grid_slime2",
          radius=1,
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          buffer=0,
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          height=0,
          prop="bandiforest_grid_slime3",
          radius=1,
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="mossy_rocks",
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=2, to=2,},},
            near_boss={ easing="linear", likelihood={ from=2, to=2,},},
            start_run={ easing="linear", likelihood={ from=2, to=2,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=3.0, height=0, radius=1.9,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
        {
          buffer=0,
          count=4.0,
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=2, to=2,},},
            near_boss={ easing="linear", likelihood={ from=2, to=2,},},
            start_run={ easing="linear", likelihood={ from=2, to=2,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          height=0,
          radius=1,
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG21",
      zones={ "inside_perimeter", "front_perimeter",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="entrance_middle_tree",
      non_walkable=false,
      offstage=false,
      particle_systems={  },
      room_types={ "entrance",},
      scene_props={
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=0, to=0,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=1,},
          prop="destructible_twigslime_shorty",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=0, to=0,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.5, count=1, height=0, radius=1,},
          prop="destructible_twigslime_tall",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="entrance_middle_tree",
      seed_from="",
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=5.0, height=0, radius=2.0,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=5.0, height=0, radius=3,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG22",
      zones={ "middle",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="entrance_middle_fill",
      non_walkable=false,
      offstage=false,
      particle_systems={  },
      room_types={ "entrance",},
      scene_props={
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=1,},
          prop="bandiforest_grid_slime",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=1,},
          prop="bandiforest_grid_slime2",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=1,},
          prop="bandiforest_grid_slime3",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="entrance_middle_tree",
      spacers={
        {
          buffer=0,
          count=4.0,
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          height=0,
          radius=2.0,
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=4.0, height=0, radius=3.0,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG23",
      zones={ "middle",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="Physics: non-walkable",
      non_walkable=true,
      offstage=false,
      particle_systems={  },
      room_types={ "boss", "empty", "hype", "insert", "miniboss", "monster", "metaunlock",},
      scene_props={
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="inCubic", likelihood={ from=1, to=0.30000001192093,},},
            near_boss={ easing="outQuint", likelihood={ from=0.30000001192093, to=0,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.94999998807907, count=10.0, height=0, radius=0.17499999701977,},
          prop="bandiforest_grid_reed",
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="inCubic", likelihood={ from=1.0, to=0.30000001192093,},},
            near_boss={ easing="outQuint", likelihood={ from=0.30000001192093, to=0,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.85000002384186, count=9.0, height=0, radius=0.10000000149012,},
          prop="bandiforest_grid_reedsml",
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="inCubic", likelihood={ from=0.0, to=0.69999998807907,},},
            near_boss={ easing="outQuint", likelihood={ from=0.69999998807907, to=1.0,},},
            start_run={ easing="linear", likelihood={ from=0.0, to=0.0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.94999998807907, count=10, height=0, radius=0.17499999701977,},
          prop="bandiforest_grid_reedblue",
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="inCubic", likelihood={ from=0, to=0.69999998807907,},},
            near_boss={ easing="outQuint", likelihood={ from=0.69999998807907, to=1,},},
            start_run={ easing="linear", likelihood={ from=0, to=0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.85000002384186, count=9, height=0, radius=0.10000000149012,},
          prop="bandiforest_grid_reedsmlblue",
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      spacers={  },
      tag="ZONE_GEN_TAG24",
      zones={ "non_walkable_fg", "non_walkable_bg",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="arena_perimeter",
      non_walkable=false,
      offstage=false,
      particle_systems={  },
      room_types={ "empty", "miniboss", "monster", "insert",},
      scene_props={
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=true,
          flags={  },
          placement={ buffer=1.0, count=1, height=0, radius=1,},
          prop="bandiforest_grid_slime",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=true,
          flags={  },
          placement={ buffer=0.5, count=1, height=0, radius=1,},
          prop="bandiforest_grid_slime2",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=true,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=1,},
          prop="bandiforest_grid_slime3",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="",
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=2, to=2,},},
            near_boss={ easing="linear", likelihood={ from=2, to=2,},},
            start_run={ easing="linear", likelihood={ from=2, to=2,},},
          },
          enabled=true,
          filter_by_tile_type=true,
          placement={ buffer=0, count=2.0, height=0, radius=1.9,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=2.0, to=2.0,},},
            near_boss={ easing="linear", likelihood={ from=2.0, to=2.0,},},
            start_run={ easing="linear", likelihood={ from=2.0, to=2.0,},},
          },
          enabled=true,
          filter_by_tile_type=true,
          placement={ buffer=0, count=2.0, height=0, radius=1,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      tag="ZONE_GEN_TAG25",
      zones={ "inside_perimeter", "front_perimeter",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="arena_middle",
      non_walkable=false,
      offstage=false,
      particle_systems={  },
      room_types={ "empty", "insert", "miniboss", "monster",},
      scene_props={
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=true,
          flags={  },
          placement={ buffer=1.0, count=1, height=0, radius=1,},
          prop="bandiforest_grid_slime",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=true,
          flags={  },
          placement={ buffer=0.5, count=1, height=0, radius=1,},
          prop="bandiforest_grid_slime2",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=true,
          flags={  },
          placement={ buffer=0.0, count=1, height=0, radius=1,},
          prop="bandiforest_grid_slime3",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="",
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=true,
          placement={ buffer=0, count=6.0, height=0, radius=2.5,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=true,
          placement={ buffer=0, count=4.0, height=0, radius=2,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=true,
          placement={ buffer=0, count=4.0, height=0, radius=1,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      tag="ZONE_GEN_TAG26",
      zones={ "middle",},
    },
    {
      can_obscure_features=false,
      decor_layer="Canopy",
      enabled=true,
      fxes={  },
      non_walkable=false,
      offstage=true,
      particle_systems={  },
      room_types={
        "boss",
        "empty",
        "entrance",
        "food",
        "hype",
        "insert",
        "miniboss",
        "monster",
        "mystery",
        "potion",
        "powerupgrade",
        "ranger",
        "resource",
        "market",
        "wanderer",
        "metaunlock",
        "quest",
      },
      scene_props={
        {
          buffer=3,
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.69999998807907, to=0,},},
            near_boss={ easing="outQuad", likelihood={ from=0, to=0,},},
            start_run={ easing="inQuart", likelihood={ from=1, to=0.69999998807907,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          height=0,
          prop="bandiforest_ul_canopy",
          radius=1.0,
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          buffer=3,
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.69999998807907, to=0,},},
            near_boss={ easing="outQuad", likelihood={ from=0, to=0,},},
            start_run={ easing="inQuart", likelihood={ from=1, to=0.69999998807907,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          height=-3.0,
          name="bandiforest_ul_canopy_lower",
          prop="bandiforest_ul_canopy",
          radius=1.0,
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          buffer=3.0,
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.30000001192093, to=1,},},
            near_boss={ easing="outQuad", likelihood={ from=1, to=1,},},
            start_run={ easing="inQuart", likelihood={ from=0, to=0.30000001192093,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          height=0,
          prop="bandiforest_ul_canopy",
          radius=1.0,
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          buffer=3,
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.30000001192093, to=1,},},
            near_boss={ easing="outQuad", likelihood={ from=1, to=1,},},
            start_run={ easing="inQuart", likelihood={ from=0, to=0.30000001192093,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          height=-3.0,
          name="bandiforest_ul_canopy_lower",
          prop="bandiforest_ul_canopy",
          radius=1.0,
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="",
      spacers={
        {
          buffer=0,
          count=1.0,
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=0.0010000000474975,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          height=0,
          radius=1.0,
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG27",
      zones={ "underlay",},
    },
    {
      can_obscure_features=true,
      decor_layer="Canopy",
      enabled=true,
      fxes={  },
      name="up_canopy_distant",
      non_walkable=false,
      offstage=true,
      particle_systems={  },
      room_types={
        "boss",
        "empty",
        "entrance",
        "food",
        "hype",
        "insert",
        "miniboss",
        "monster",
        "mystery",
        "potion",
        "powerupgrade",
        "ranger",
        "resource",
        "wanderer",
        "market",
        "metaunlock",
        "quest",
      },
      scene_props={
        {
          color_variants={
            {
              color={ brightness=28, hue=0, saturation=0,},
              likelihood=1,
              zones={ "distant_bg",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.80000001192093, to=0.20000000298023,},},
            near_boss={ easing="outCubic", likelihood={ from=0.20000000298023, to=0.0,},},
            start_run={ easing="inQuart", likelihood={ from=1, to=0.80000001192093,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=3.0, count=1, height=0.0, radius=1.0,},
          prop="bandiforest_up_canopy_vine",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={
            {
              color={ brightness=23, hue=-18, saturation=-15,},
              likelihood=1,
              zones={ "distant_bg",},
            },
          },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.20000000298023, to=0.80000001192093,},},
            near_boss={ easing="outCubic", likelihood={ from=0.80000001192093, to=1.0,},},
            start_run={ easing="inQuart", likelihood={ from=0.0, to=0.20000000298023,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=3, count=1, height=0.0, radius=1.0,},
          prop="bandiforest_up_canopyslime",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="",
      spacers={
        {
          buffer=0,
          count=5.0,
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          height=0,
          radius=3.0,
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG28",
      zones={ "bg", "distant_bg",},
    },
    {
      can_obscure_features=true,
      decor_layer="Canopy",
      enabled=true,
      fxes={  },
      name="up_canopy_near",
      non_walkable=false,
      offstage=true,
      particle_systems={  },
      room_types={
        "boss",
        "empty",
        "entrance",
        "food",
        "hype",
        "insert",
        "miniboss",
        "monster",
        "mystery",
        "potion",
        "powerupgrade",
        "ranger",
        "resource",
        "wanderer",
        "market",
        "metaunlock",
        "quest",
      },
      scene_props={
        {
          color_variants={ { color={ brightness=0, hue=0, saturation=0,}, likelihood=1, zones={ "bg",},},},
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.80000001192093, to=0.20000000298023,},},
            near_boss={ easing="outCubic", likelihood={ from=0.20000000298023, to=0,},},
            start_run={ easing="inQuart", likelihood={ from=1, to=0.80000001192093,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=3.0, count=1, height=2.0, radius=2.0,},
          prop="bandiforest_up_canopy_vine",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.20000000298023, to=0.80000001192093,},},
            near_boss={ easing="outCubic", likelihood={ from=0.80000001192093, to=1,},},
            start_run={ easing="inQuart", likelihood={ from=0, to=0.20000000298023,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=3, count=1, height=2.0, radius=2.0,},
          prop="bandiforest_up_canopyslime",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="",
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=1.0, count=1.0, height=0, radius=2.0,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG29",
      zones={ "near_bg", "distant_side", "side",},
    },
    {
      can_obscure_features=true,
      decor_layer="Canopy",
      enabled=true,
      fxes={  },
      name="entrance_quest_up_canopy_middle",
      non_walkable=false,
      offstage=true,
      particle_systems={  },
      room_types={ "entrance", "quest",},
      scene_props={
        {
          color_variants={
            { color={ brightness=-9, hue=0, saturation=5,}, likelihood=1, zones={ "side",},},
          },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.80000001192093, to=0.20000000298023,},},
            near_boss={ easing="outCubic", likelihood={ from=0.20000000298023, to=0,},},
            start_run={ easing="inQuart", likelihood={ from=1, to=0.80000001192093,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=3, count=1, height=2.0, radius=1,},
          prop="bandiforest_up_canopy_vine",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={ { color={ brightness=-7, hue=0, saturation=6,}, likelihood=1,},},
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.20000000298023, to=0.80000001192093,},},
            near_boss={ easing="outCubic", likelihood={ from=0.80000001192093, to=1,},},
            start_run={ easing="inQuart", likelihood={ from=0, to=0.20000000298023,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          name="bandiforest_up_canopy_vine_lower",
          placement={ buffer=3, count=1, height=0.0, radius=1,},
          prop="bandiforest_up_canopy_vine",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="",
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=5.0, height=0, radius=3,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG30",
      zones={ "middle",},
    },
    {
      can_obscure_features=true,
      decor_layer="Canopy",
      enabled=true,
      fxes={  },
      name="up_canopy_middle",
      non_walkable=false,
      offstage=true,
      particle_systems={  },
      room_types={
        "boss",
        "empty",
        "food",
        "hype",
        "insert",
        "miniboss",
        "monster",
        "mystery",
        "potion",
        "powerupgrade",
        "ranger",
        "resource",
        "wanderer",
        "market",
        "metaunlock",
      },
      scene_props={
        {
          color_variants={
            { color={ brightness=-9, hue=0, saturation=5,}, likelihood=1, zones={ "side",},},
          },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.80000001192093, to=0.20000000298023,},},
            near_boss={ easing="outCubic", likelihood={ from=0.20000000298023, to=0,},},
            start_run={ easing="inQuart", likelihood={ from=1, to=0.80000001192093,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=3.0, count=1, height=4.0, radius=1.0,},
          prop="bandiforest_up_canopy_vine",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={ { color={ brightness=-7.0, hue=0, saturation=6.0,}, likelihood=1,},},
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.20000000298023, to=0.80000001192093,},},
            near_boss={ easing="outCubic", likelihood={ from=0.80000001192093, to=1,},},
            start_run={ easing="inQuart", likelihood={ from=0, to=0.20000000298023,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=3, count=1, height=4.0, radius=1.0,},
          prop="bandiforest_up_canopyslime",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="",
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=10.0, height=0, radius=3,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG31",
      zones={ "middle",},
    },
    {
      can_obscure_features=true,
      decor_layer="Canopy",
      enabled=false,
      fxes={  },
      name="entrance_fg_canopy",
      non_walkable=false,
      offstage=true,
      particle_systems={  },
      room_types={ "entrance",},
      scene_props={
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.80000001192093, to=0.20000000298023,},},
            near_boss={ easing="outCubic", likelihood={ from=0.20000000298023, to=0,},},
            start_run={ easing="inQuart", likelihood={ from=1, to=0.80000001192093,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=3, count=1, height=5, radius=2,},
          prop="bandiforest_fg_canopy",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1.0, to=1.0,},},
            near_boss={ easing="outCubic", likelihood={ from=1.0, to=1,},},
            start_run={ easing="inQuart", likelihood={ from=1.0, to=1.0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          name="bandiforest_fg_canopy_lower",
          placement={ buffer=3, count=1, height=2.0, radius=2,},
          prop="bandiforest_fg_canopy",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="",
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=5.0, height=0, radius=2,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG32",
      zones={ "fg", "distant_fg", "front_perimeter",},
    },
    {
      can_obscure_features=true,
      decor_layer="Canopy",
      enabled=false,
      fxes={  },
      name="fg_canopy",
      non_walkable=false,
      offstage=true,
      particle_systems={  },
      room_types={
        "boss",
        "empty",
        "food",
        "hype",
        "insert",
        "miniboss",
        "monster",
        "mystery",
        "potion",
        "powerupgrade",
        "ranger",
        "resource",
        "wanderer",
        "market",
      },
      scene_props={
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.80000001192093, to=0.20000000298023,},},
            near_boss={ easing="outCubic", likelihood={ from=0.20000000298023, to=0,},},
            start_run={ easing="inQuart", likelihood={ from=1, to=0.80000001192093,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=3.0, count=1, height=5.0, radius=2.0,},
          prop="bandiforest_fg_canopy",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.20000000298023, to=0.80000001192093,},},
            near_boss={ easing="outCubic", likelihood={ from=0.80000001192093, to=1,},},
            start_run={ easing="inQuart", likelihood={ from=0, to=0.20000000298023,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=3.0, count=1, height=5.0, radius=2.0,},
          prop="bandiforest_fg_canopyslime",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="",
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=6.0, height=0, radius=2.0,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG33",
      zones={ "fg", "distant_fg",},
    },
    {
      can_obscure_features=true,
      decor_layer="Canopy",
      enabled=true,
      fxes={  },
      name="fg_canopy_side",
      non_walkable=false,
      offstage=true,
      particle_systems={  },
      room_types={
        "boss",
        "empty",
        "entrance",
        "food",
        "hype",
        "insert",
        "miniboss",
        "monster",
        "mystery",
        "potion",
        "powerupgrade",
        "ranger",
        "resource",
        "wanderer",
        "market",
        "metaunlock",
        "quest",
      },
      scene_props={
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.80000001192093, to=0.20000000298023,},},
            near_boss={ easing="outCubic", likelihood={ from=0.20000000298023, to=0,},},
            start_run={ easing="inQuart", likelihood={ from=1, to=0.80000001192093,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=3.0, count=2.0, height=1.5, radius=2.0,},
          prop="bandiforest_fg_canopy",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.80000001192093, to=0.20000000298023,},},
            near_boss={ easing="outCubic", likelihood={ from=0.20000000298023, to=0,},},
            start_run={ easing="inQuart", likelihood={ from=1, to=0.80000001192093,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          name="bandiforest_fg_canopy_higher",
          placement={ buffer=3.0, count=1, height=2.5, radius=2.0,},
          prop="bandiforest_fg_canopy",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={ { color={ brightness=-16.0, hue=0, saturation=8.0,}, likelihood=1,},},
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.20000000298023, to=0.80000001192093,},},
            near_boss={ easing="outCubic", likelihood={ from=0.80000001192093, to=1,},},
            start_run={ easing="inQuart", likelihood={ from=0, to=0.20000000298023,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=3.0, count=2.0, height=1.5, radius=2.0,},
          prop="bandiforest_fg_canopyslime",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={ { color={ brightness=-16, hue=0, saturation=8,}, likelihood=1,},},
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0.20000000298023, to=0.80000001192093,},},
            near_boss={ easing="outCubic", likelihood={ from=0.80000001192093, to=1,},},
            start_run={ easing="inQuart", likelihood={ from=0, to=0.20000000298023,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          name="bandiforest_fg_canopyslime_higher",
          placement={ buffer=3.0, count=2, height=2.5, radius=2.0,},
          prop="bandiforest_fg_canopyslime",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="",
      spacers={
        {
          buffer=0,
          count=1.0,
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          height=0,
          radius=2,
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG34",
      zones={ "fg_side",},
    },
    {
      can_obscure_features=true,
      decor_layer="Shadow",
      enabled=true,
      fxes={  },
      name="shadow_perimeter",
      non_walkable=false,
      offstage=true,
      particle_systems={  },
      room_types={ "boss", "empty", "hype", "insert", "miniboss", "monster",},
      scene_props={
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=4.0, count=3.0, height=0, radius=1.0,},
          prop="canopy_shadow_bubblebranches",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="",
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=1.0, height=0, radius=1.0,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG35",
      zones={ "near_side", "near_fg", "near_bg",},
    },
    {
      can_obscure_features=true,
      decor_layer="Shadow",
      enabled=true,
      fxes={  },
      name="shadow_perimeter_SAFE",
      non_walkable=false,
      offstage=true,
      particle_systems={  },
      room_types={
        "entrance",
        "food",
        "mystery",
        "potion",
        "powerupgrade",
        "ranger",
        "wanderer",
        "market",
        "resource",
        "quest",
        "metaunlock",
      },
      scene_props={
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=3.0, count=3.0, height=0, radius=1,},
          prop="canopy_shadow_bubblebranches",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="",
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=1.0, height=0, radius=1,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG36",
      zones={ "near_side", "near_fg", "near_bg",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="Particles: Fog",
      non_walkable=false,
      offstage=true,
      particle_systems={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={ "centered", "unique",},
          particle_system="fog_swamp_billboard_bg",
          placement={ buffer=0, count=1, height=0, radius=1,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      room_types={
        "boss",
        "empty",
        "entrance",
        "food",
        "hype",
        "insert",
        "market",
        "miniboss",
        "monster",
        "mystery",
        "potion",
        "powerupgrade",
        "quest",
        "ranger",
        "resource",
        "wanderer",
        "metaunlock",
      },
      scene_props={  },
      spacers={  },
      tag="ZONE_GEN_TAG37",
      zones={ "underlay",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="metaunlock_perimeter",
      non_walkable=false,
      offstage=false,
      particle_systems={  },
      room_types={ "metaunlock",},
      scene_props={
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=true,
          flags={  },
          placement={ buffer=0.20000000298023, count=1, height=0, radius=1.5,},
          prop="bandiforest_grid_lilyrock1",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=true,
          flags={  },
          placement={ buffer=0.20000000298023, count=1, height=0, radius=1.0,},
          prop="bandiforest_grid_lilyrock2",
          tile_type_filter_shape="Circle",
          tile_types={ "path", "rough",},
        },
      },
      seed="mossy_rocks",
      seed_from="",
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=1.0, height=0, radius=2.0,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=1.0, height=0, radius=1,},
          tile_type_filter_shape="Point",
        },
      },
      tag="ZONE_GEN_TAG38",
      zones={ "front_perimeter", "inside_perimeter",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="metaunlock_perimeter_fill",
      non_walkable=false,
      offstage=false,
      particle_systems={  },
      room_types={ "metaunlock",},
      scene_props={
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=true,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=1,},
          prop="bandiforest_grid_slime",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=true,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=1,},
          prop="bandiforest_grid_slime2",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=true,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=1,},
          prop="bandiforest_grid_slime3",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="mossy_rocks",
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=2, to=2,},},
            near_boss={ easing="linear", likelihood={ from=2, to=2,},},
            start_run={ easing="linear", likelihood={ from=2, to=2,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=3, height=0, radius=1.5,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=2, to=2,},},
            near_boss={ easing="linear", likelihood={ from=2, to=2,},},
            start_run={ easing="linear", likelihood={ from=2, to=2,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=2.0, height=0, radius=1,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG39",
      zones={ "inside_perimeter", "front_perimeter",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="metaunlock_middle",
      non_walkable=false,
      offstage=false,
      particle_systems={  },
      room_types={ "metaunlock",},
      scene_props={
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=0, to=0,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=1,},
          prop="destructible_twigslime_shorty",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=0, to=0,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.5, count=1, height=0, radius=1,},
          prop="destructible_twigslime_tall",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=1,},
          prop="bandiforest_grid_slime",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=true,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=1,},
          prop="bandiforest_grid_slime2",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=true,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=1,},
          prop="bandiforest_grid_slime3",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="entrance_middle_tree",
      seed_from="",
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=5, height=0, radius=2,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=5, height=0, radius=3,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG40",
      zones={ "middle",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="quest_perimeter",
      non_walkable=false,
      offstage=false,
      particle_systems={  },
      room_types={ "quest",},
      scene_props={
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.80000001192093, count=1, height=0, radius=0.80000001192093,},
          prop="bandiforest_grid_lilyrock1",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.44999998807907, count=1, height=0, radius=0.75,},
          prop="bandiforest_grid_lilyrock2",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="mossy_rocks",
      seed_from="",
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=2, count=2, height=0, radius=1,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=1.5, count=3, height=0, radius=0.5,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG41",
      zones={ "front_perimeter", "inside_perimeter",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="quest_perimeter_fill",
      non_walkable=false,
      offstage=false,
      particle_systems={  },
      room_types={ "quest",},
      scene_props={
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=1,},
          prop="bandiforest_grid_slime",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=0.80000001192093,},
          prop="bandiforest_grid_slime2",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=0.5,},
          prop="bandiforest_grid_slime3",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="mossy_rocks",
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=2, to=2,},},
            near_boss={ easing="linear", likelihood={ from=2, to=2,},},
            start_run={ easing="linear", likelihood={ from=2, to=2,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=3, height=0, radius=1.9,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=2, to=2,},},
            near_boss={ easing="linear", likelihood={ from=2, to=2,},},
            start_run={ easing="linear", likelihood={ from=2, to=2,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=5, height=0, radius=1,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG42",
      zones={ "inside_perimeter", "front_perimeter",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="quest_middle_tree",
      non_walkable=false,
      offstage=false,
      particle_systems={  },
      room_types={ "quest",},
      scene_props={
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=0, to=0,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.5, count=1, height=0, radius=1,},
          prop="destructible_twigslime_shorty",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=0, to=0,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1, count=1, height=0, radius=1,},
          prop="destructible_twigslime_tall",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0, to=0,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=0, to=0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0.5, count=1, height=0, radius=1,},
          prop="destructible_deadbug_shorty",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=0, to=0,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=0, to=0,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=1, count=1, height=0, radius=1,},
          prop="destructible_deadbug_tall",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="entrance_middle_tree",
      seed_from="",
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=6, height=0, radius=2,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=7, height=0, radius=3,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=5, height=0, radius=1,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG43",
      zones={ "middle",},
    },
    {
      can_obscure_features=false,
      decor_layer="Ground",
      enabled=true,
      fxes={  },
      name="quest_middle_fill",
      non_walkable=false,
      offstage=false,
      particle_systems={  },
      room_types={ "quest",},
      scene_props={
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=1,},
          prop="bandiforest_grid_slime",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=1,},
          prop="bandiforest_grid_slime2",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
        {
          color_variants={  },
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          flags={  },
          placement={ buffer=0, count=1, height=0, radius=1,},
          prop="bandiforest_grid_slime3",
          tile_type_filter_shape="Point",
          tile_types={ "path", "rough",},
        },
      },
      seed="",
      seed_from="entrance_middle_tree",
      spacers={
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=5, height=0, radius=2,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=4, height=0, radius=3,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
        {
          dungeon_progress_constraints={
            midway={ easing="linear", likelihood={ from=1, to=1,},},
            near_boss={ easing="linear", likelihood={ from=1, to=1,},},
            start_run={ easing="linear", likelihood={ from=1, to=1,},},
          },
          enabled=true,
          filter_by_tile_type=false,
          placement={ buffer=0, count=6, height=0, radius=1,},
          tile_type_filter_shape="Point",
          tile_types={ "path", "pool", "rough",},
        },
      },
      tag="ZONE_GEN_TAG44",
      zones={ "middle",},
    },
  },
}
t.lighting = t.environments[1].lighting
t.sky = t.environments[1].sky
t.water = t.environments[1].water
return t
